package gov.va.med.mhv.vitals.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="BODY_TEMPERATURE_READINGS")
public class BodyTemperatureReading implements Serializable{

	private static final long serialVersionUID = -8548568608938295177L;
	
	@Id
	@Column(name="BODY_TEMPERATURE_ID_SEQ")
	@GeneratedValue(strategy=GenerationType.AUTO)
	private Long id;
	
	@Column(name="OPLOCK")
	private Integer oplock;
	
	@Column(name="READING")
	@Temporal(TemporalType.TIMESTAMP)
	private Date reading;

	
	@Column(name="COMMENTS")
	private String comments;
	
	@Column(name="BODY_TEMPERATURE_METHOD")
    private String bodyTemperatureMethod;
    
	@Column(name="BODY_TEMPERATURE")
    private BigDecimal bodyTemperature;
    
	@Column(name="BODY_TEMPERATURE_MEASURE")
    private String  measure;
    
    
	@Column(name="USER_PROFILE_USER_PROFILE_ID")
	private Long userprofileId;


	public Long getId() {
		return id;
	}


	public void setId(Long id) {
		this.id = id;
	}


	public Integer getOplock() {
		return oplock;
	}


	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}


	public Date getReading() {
		return reading;
	}


	public void setReading(Date reading) {
		this.reading = reading;
	}


	public String getComments() {
		return comments;
	}


	public void setComments(String comments) {
		this.comments = comments;
	}


	public String getBodyTemperatureMethod() {
		return bodyTemperatureMethod;
	}


	public void setBodyTemperatureMethod(String bodyTemperatureMethod) {
		this.bodyTemperatureMethod = bodyTemperatureMethod;
	}


	public BigDecimal getBodyTemperature() {
		return bodyTemperature;
	}


	public void setBodyTemperature(BigDecimal bodyTemperature) {
		this.bodyTemperature = bodyTemperature;
	}


	public String getMeasure() {
		return measure;
	}


	public void setMeasure(String measure) {
		this.measure = measure;
	}


	public Long getUserprofileId() {
		return userprofileId;
	}


	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}

}
